Ext.define('KitchenSink.locale.store.Navigation', {
    override: 'KitchenSink.store.Navigation',
    title: 'דוגמאות',

    descriptions: {
        'panels': 'פנלים הם מיכל הבסיסי המרכיב את המבנה של רוב היישומים. יש פנלים כותרת ובגוף, והוא יכול להיות מסודר בדרכים שונות באמצעות פריסות.'
    },

    translations: {
        'Panels': 'פנלים',
        'Basic Panel': 'פנל בסיסי',
        'Framed Panel': 'פנל ממוסגר',
        'Header Positioning': 'מיצוב כותרת',
        
        'Grids': 'רשתות',
        'Basic Grid': 'רשת מערך',
        'Grouped Grid': 'רשת מקובצת ',
        'Locking Grid': 'רשת קפוא',
        'Grouped Header Grid': 'רשת כותרת מקובצים',
        'Multiple Sort Grid': 'רשת רבת מיון',
        'Progress Bar Pager': 'סרגל התקדמות עם החלפה',
        'Sliding Pager': 'סרגל התקדמות עם מחוון',
        'XML Grid': 'רשת ה-XML',
        'Grid Filtering': 'סינון רשת',
        'Reconfigure Grid': 'שינוי תצורה של רשתות',
        'Property Grid': 'רשת מאפיינים',
        'Cell Editing': 'עריכה בתוך תאים',
        'Row Expander': 'מרחיב שורות',
        'Big Data': 'נתונים גדולים',
        'Widget grid': 'רשת יישומון',
        //{ id: 'customer-grid', text: 'רשת לקוחות / סדר', leaf: true },
        'Grid Plugins': 'רשת תוספים',

        'Data Binding': 'נתונים מחייבים',
        'Hello World': 'שלום עולם',
        'Dynamic': 'דינמי',
        'Two Way': 'שתי בדרך',
        'Formulas': 'נוסחאות',
        'Associations': 'הִתלַכְּדוּת',
        'Component State': 'מצב רכיב',
        'Chaining Stores': 'שרשור חנויות',
        'Chained ComboBoxes': 'תיבות משולבות משורשרות',
        'Chaining Selection': 'מבחר שרשור',
        'Model Validation': 'אימות מודל',
        'Field Validation': 'אימות שדה',
        'Two-Way Formulas': 'נוסחאות דו כיוונית',
        'Slider and Form Fields': 'שדות מחוון וצורה',
        'Isolated Child Sessions': 'מפגשי ילד מבודדים',

        'Trees': 'תצוגות עץ',
        'Basic Trees': 'תצוגות עץ בסיסיות',
        'Tree Reorder': 'מיון תצוגות עץ',
        'Tree Grid': 'רשת עץ',
        'Two Trees': 'שתי תצוגות עץ',
        'Check Tree': 'תצוגות עץ עם תיבות סימון',
        'XML Tree': 'XML תצוגות עץ',
        'Filtered Tree': 'עץ מסונן',
        'Heterogeneous Tree': 'עץ הטרוגנית',
        'Linear Data Geographical Tree': 'עץ גיאוגרפי ליניארי נתונים',

        'Tabs': 'כרטיסיות',
        'Basic Tabs': 'כרטיסיות בסיסיות',
        'Plain Tabs': 'כרטיסיות רגילות',
        'Framed Tabs': 'כרטיסיות ממוסגרות',
        'Icon Tabs': 'כרטיסיות סמלים',
        'Ajax Tabs': 'כרטיסיות אייאקס',
        'Advanced Tabs': 'כרטיסיות מתקדמות',
        'Navigation Tabs': 'כרטיסיות ניווט',
        'Side Navigation Tabs': 'כרטיסיות ניווט צד',
        'Header Tabs': 'כרטיסיות כותרת',
        'Reorderable Tabs': 'סדר כרטיסיות שינוי',

        'Windows': 'חלונות',
        'Basic Window': 'חלון בסיסי',
        'Message Box': 'תיבת הודעה',

        'Buttons': 'לחצנים',
        'Basic Buttons': 'לחצנים בסיסיים',
        'Toggle Buttons': 'לחצנים דו-מצבים',
        'Menu Buttons': 'לחצני תפריט',
        'Menu Bottom Buttons': 'לחצני תפריט מתחת',
        'Split Buttons': 'לחצנים מפוצלים',
        'Split Bottom Buttons': 'לחצנים מפוצלים מתחת',
        'Left Text Buttons': 'לחצני טקסט משמאל',
        'Right Text Buttons': 'לחצני טקסט מימין',
        'Link Buttons': 'לחצני קישור',
        'Segmented Buttons': 'לחצנים מפולחים',
        'Vertical Segmented Buttons': 'לחצנים אנכיים מקוטע',

        'DataView': 'תצוגת נתונים',
        'Multisort DataView': 'תצוגת נתונים רבת מיון',

        'Form Fields': 'שדות טופס',
        'Number Field': 'מספר שדה',
        'Date/Month Picker': 'תאריך / חודש פיקר',
        'File Uploads': 'העלאת קבצים',
        'Field Replicator': 'מעתק שדה',
        'Form with Grid': 'טופס עם גריד',
        'Tag Field': 'שדה תג',
        'Multi-Selector Grid': 'רב בורר גריד',
        'Field Types': 'סוגי שדות',
        'Field Container': 'שדה מכולות',
        'Checkbox Groups': 'קבוצות תיבת הסימון',
        'Radio Groups': 'קבוצות לחצן אפשרויות',
        'Slider Field': 'מחוון שדה',

        'Forms': 'טפסים',
        'Login Form': 'טופס כניסה',
        'Contact Form': 'בטופס איש הקשר',
        'Register Form': 'טופס הרשמה',
        'Checkout Form': 'טופס לקופה',
        'HBox Layout': 'HBox פריסה',
        'VBox Layout': 'VBox פריסה',
        'Multi Column Form': 'טופס טור רב',
        'XML Form': 'טופס XML',
        'Custom VTypes': 'אישית VType',
        'Custom fields': 'שדות מותאמים אישית',
        'Forum Search': 'חיפוש בפורום',
        'Custom Error Handling': 'טיפול בשגיאות מותאמות אישית',

        'Toolbars': 'סרגלי כלים',
        'Reorderable Toolbar': 'סרגל כלים בסיסי',
        'Docked Toolbar': 'סרגל כלים מעוגן',
        'Breadcrumb Toolbar': 'סרגל כלים סימני דרך',

        'Layouts': 'פריסה',
        'Absolute Layout': 'פריסה מוחלטת',
        'Accordion Layout': 'פריסת אקורדיון',
        'Border Layout': 'פריסת גבול',
        'Card Layout': 'פריסת כרטיס',
        'Card (Tabs)': 'כרטיס (כרטיסיות)',
        'Center Layout': 'מרכז פריסה',
        'Column Layout': 'פריסת עמודה',
        'Fit Layout': 'פריסת Fit',
        'Table Layout': 'פריסת שולחן',

        'Drag & Drop': 'גרירה ושחרור',
        'Field to Grid': 'משדה לרשת',
        'Grid to Form': 'משדה לטופס',
        'Grid to Grid': 'מרשת לרשת',

        'Enterprise': 'מפעל',
        'AMF Grid': 'AMF רשת',
        'SOAP Grid': 'רשת SOAP'
    },
    
    fixUp: function (items, tier, parent) {
        var me = this,
            descriptions = me.descriptions,
            translations = me.translations,
            item = items,
            s;
        
        me.callParent([ items, tier, parent ]);
        
        if (!Ext.isArray(item)) {
            s = descriptions[item.id];
            if (s) {
                item.description = s;
            }
            
            s = item.text;
            item.text = translations[s] || s;
        }
    }
});
